/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Actor     ground , // ground actor
          box[3] ; // stairs
CSkeleton cskel  ; // controlled skeleton
Ragdoll   ragdoll; // ragdoll
/******************************************************************************/
void SetPose()
{
   cskel.clear().updateMatrix(Matrix().setRotateX(0.45).move(Vec(0,3,0))).updateVelocities(); // set skeleton animation to default pose and custom matrix

   ragdoll.fromSkel(cskel); // setup ragdoll from skeleton animation
}
/******************************************************************************/
void InitPre()
{
   App.name="Ragdoll";
   App.flag=APP_MS_EXCLUSIVE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true);
   Cam.dist =5;
   Cam.pitch=-0.3;
   Cam.yaw  =PI;
}
Bool Init()
{
   Physics.create();

   ground.create(Box_U(15,1,15,Vec(0,-1,0)),0);
   REPA(box)box[i].create(Box(1,Vec(0,i*0.5-0.5,i*-0.5-0.3)),0);

   cskel  .create("obj/chr/skeleton/0.skel",1.8); // create skeleton
   ragdoll.create(cskel);                         // create ragdoll from skeleton

   SetPose();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,100,CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT)); // move camera on right mouse button

   Physics.sim().get();

   ragdoll.toSkel(cskel); // set skeleton from ragdoll

   if(Kb.bp(KB_SPACE))SetPose();

   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear();
   LightDir(1,Cam.matrix.z).set();

   Meshs("obj/chr/skeleton/0.mesh")->draw(cskel);

   Physics.draw();

   D.text(0,0.9,"Press Space to reset simulation");
}
/******************************************************************************/
